/////////////////////////////////////////////////////////////////////////////
// GTDevmonSampleDlg.cpp : Implementation file.

#include "stdafx.h"
#include "GTDevmonSample.h"
#include "GTDevmonSampleDlg.h"
#include "GDevlib_GT27.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static UINT BASED_CODE indicators[] =
{
	// Status line indicator.
	IDS_SEPARATOR_SP,
	ID_SEPARATOR,
	IDS_SEPARATOR_SP2,
};

/////////////////////////////////////////////////////////////////////////////
// CGTDevmonSampleDlg Dialog.

CGTDevmonSampleDlg::CGTDevmonSampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGTDevmonSampleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGTDevmonSampleDlg)
	m_uiGD_Dev_Num = 0;
	m_uiGB_Dev_Num = 0;
	m_uiGS_Dev_Num = 0;
	m_hDev_MapFile = NULL;
	m_ulDev_MapPointer = 0;
	m_bDevMoniFlag = false;
	m_iGD_Write_Val = 0;
	m_iGS_Write_Val = 0;
	//}}AFX_DATA_INIT
	// Memo: LoadIcon does not demand the subsequence of DestroyIcon of Win32.
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

/////////////////////////////////////////////////////////////////////////////
//

void CGTDevmonSampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGTDevmonSampleDlg)
	DDX_Control(pDX, IDC_MON_START_BTN, m_MonStartCap);
	DDX_Text(pDX, IDC_GD_EDIT, m_uiGD_Dev_Num);
	DDV_MinMaxUInt(pDX, m_uiGD_Dev_Num, 0, 65535);
	DDX_Text(pDX, IDC_GB_EDIT, m_uiGB_Dev_Num);
	DDV_MinMaxUInt(pDX, m_uiGB_Dev_Num, 0, 65535);
	DDX_Text(pDX, IDC_GS_EDIT, m_uiGS_Dev_Num);
	DDV_MinMaxUInt(pDX, m_uiGS_Dev_Num, 0, 2047);
	DDX_Text(pDX, IDC_GD_EDIT_W, m_iGD_Write_Val);
	DDV_MinMaxInt(pDX, m_iGD_Write_Val, -32768, 32767);
	DDX_Text(pDX, IDC_GS_EDIT_W, m_iGS_Write_Val);
	DDV_MinMaxInt(pDX, m_iGS_Write_Val, -32768, 32767);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// Message Map.

BEGIN_MESSAGE_MAP(CGTDevmonSampleDlg, CDialog)
	//{{AFX_MSG_MAP(CGTDevmonSampleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_GD_W_BTN, OnGdWriteBtn)
	ON_BN_CLICKED(IDC_GB_BTN_ON, OnGbOnBtn)
	ON_BN_CLICKED(IDC_GB_BTN_OFF, OnGbOffBtn)
	ON_BN_CLICKED(IDC_GS_W_BTN, OnGsWriteBtn)
	ON_BN_CLICKED(IDC_MON_START_BTN, OnMonStartBtn)
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_EN_KILLFOCUS(IDC_GB_EDIT, OnKillfocusGbEdit)
	ON_EN_KILLFOCUS(IDC_GD_EDIT, OnKillfocusGdEdit)
	ON_EN_KILLFOCUS(IDC_GS_EDIT, OnKillfocusGsEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGTDevmonSampleDlg Message handler.

BOOL CGTDevmonSampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, TRUE);
	
	// Spin Range
	UDACCEL stAccel;
	CSpinButtonCtrl* pSB=(CSpinButtonCtrl*)GetDlgItem(IDC_GD_SPIN);
	pSB->SetRange32(0,65535);
	stAccel.nSec = 0;
	stAccel.nInc = 1;
	pSB->SetAccel(1,&stAccel);
	pSB->SetPos(m_uiGD_Dev_Num);

	pSB=(CSpinButtonCtrl*)GetDlgItem(IDC_GB_SPIN);
	pSB->SetRange32(0,65535);
	stAccel.nSec = 0;
	stAccel.nInc = 1;
	pSB->SetAccel(1,&stAccel);
	pSB->SetPos(m_uiGB_Dev_Num);

	pSB=(CSpinButtonCtrl*)GetDlgItem(IDC_GS_SPIN);
	pSB->SetRange32(0,2047);
	stAccel.nSec = 0;
	stAccel.nInc = 1;
	pSB->SetAccel(1,&stAccel);
	pSB->SetPos(m_uiGS_Dev_Num);

	// Tool Tip
    if (m_ToolTip.Create (this))
    {
		m_ToolTip.AddTool((CStatic *)GetDlgItem(IDC_GD_EDIT_W),		IDS_GD_EDIT_EXP);
		m_ToolTip.AddTool((CStatic *)GetDlgItem(IDC_GD_W_BTN),		IDS_GD_W_EXP);
		m_ToolTip.AddTool((CStatic *)GetDlgItem(IDC_GB_BTN_ON),		IDS_GB_ON_EXP);
		m_ToolTip.AddTool((CStatic *)GetDlgItem(IDC_GB_BTN_OFF),	IDS_GB_OFF_EXP);
		m_ToolTip.AddTool((CStatic *)GetDlgItem(IDC_GS_EDIT_W),		IDS_GS_EDIT_EXP);
		m_ToolTip.AddTool((CStatic *)GetDlgItem(IDC_GS_W_BTN),		IDS_GS_W_EXP);
		m_ToolTip.AddTool((CStatic *)GetDlgItem(IDC_MON_START_BTN),	IDS_MON_START_EXP);
		m_ToolTip.AddTool((CStatic *)GetDlgItem(IDCANCEL),			IDS_DLG_CLOSE_EXP);
    }

	// Status Bar
	if (!m_StatusBar.Create (this)){
		MessageBox (_T ("CStatusBar::Create failed"));
	}else{
		RepositionBars (AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, 0);
	}
	m_StatusBar.SetIndicators(indicators,3);
	m_StatusBar.SetPaneText(0,_T("\tGT SoftGOT2000"));
	m_StatusBar.SetPaneInfo(1,0,SBPS_STRETCH,1);
	m_StatusBar.SetPaneText(2,_T(""));

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//

void CGTDevmonSampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX){
		return;
	}else{
		CDialog::OnSysCommand(nID, lParam);
	}
}

/////////////////////////////////////////////////////////////////////////////
//

void CGTDevmonSampleDlg::OnPaint() 
{
	if (IsIconic()){
		CPaintDC dc(this); // Device context for drawing.

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center in rectangular area of client.
		int iCXIcon = GetSystemMetrics(SM_CXICON);
		int iCYIcon = GetSystemMetrics(SM_CYICON);
		CRect Rect;
		GetClientRect(&Rect);
		int iX = (Rect.Width() - iCXIcon + 1) / 2;
		int iY = (Rect.Height() - iCYIcon + 1) / 2;

		// It draws in the icon.
		dc.DrawIcon(iX, iY, m_hIcon);
	}else{
		CDialog::OnPaint();
	}
}

/////////////////////////////////////////////////////////////////////////////
//

HCURSOR CGTDevmonSampleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/////////////////////////////////////////////////////////////////////////////
// Monior Start.

void CGTDevmonSampleDlg::OnMonStartBtn() 
{
	if(m_bDevMoniFlag == false){
		if(AfxMessageBox(IDS_MONITOR_START, (MB_ICONEXCLAMATION | MB_OKCANCEL) ) == IDOK){
			m_ulDev_MapPointer = GDev_OpenMapping(&m_hDev_MapFile ,1);
			if(m_ulDev_MapPointer == 0){
				AfxMessageBox(IDS_ERROR_GTS_ACCESS, (MB_ICONSTOP | MB_OK) );
				return;
			}
			m_bDevMoniFlag = true;

			m_StatusBar.SetPaneText(2,_T("\t*"));
			m_MonStartCap.SetWindowText(_T("&Stop monitor"));

			SetTimer( 1, 100, NULL );
		}else{
			return;
		}
	}else{
		if(m_hDev_MapFile != NULL && m_ulDev_MapPointer != 0){
			if(AfxMessageBox(IDS_MONITOR_STOP, (MB_ICONEXCLAMATION | MB_OKCANCEL) ) == IDOK){
				KillTimer( 1 );
				GDev_CloseUnMapping(m_hDev_MapFile,m_ulDev_MapPointer);

				m_ulDev_MapPointer = 0;
				m_hDev_MapFile = NULL;

				m_StatusBar.SetPaneText(2,_T(""));
				m_MonStartCap.SetWindowText(_T("&Start monitor"));

				m_bDevMoniFlag = false;
			}
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// GD Device Write.

void CGTDevmonSampleDlg::OnGdWriteBtn() 
{
	char	cDevbuff[32], cValbuff[32];
	short	sData_tbl[256];
	long	lResult = 0, lInputValue = 0;

	sData_tbl[0] = 0;

	if(m_ulDev_MapPointer == 0){
		AfxMessageBox(IDS_WARNING_MON_STOP, (MB_ICONEXCLAMATION | MB_OK) );
		return;
	}

	GetDlgItemText(IDC_GD_EDIT,cDevbuff,32);
	GetDlgItemText(IDC_GD_EDIT_W,cValbuff,32);

	lInputValue = atoi(cValbuff);

	if((lInputValue >= INPUTVAL_MIN && lInputValue < 0) ||
		(lInputValue > 0 && lInputValue <= INPUTVAL_MAX) ||
		(cValbuff[0] == '0') ){
		sData_tbl[0] = (short)lInputValue;
		lResult = GDev_Write(m_ulDev_MapPointer, GD_DEV_ID, atoi(cDevbuff), (short *)sData_tbl, 1);
		switch(lResult){
		case GDEV_OK:
			break;
		case GDEV_ERR_DEV_NAME_ID:
		case GDEV_ERR_DEV_MIN_NUM:
		case GDEV_ERR_DEV_MAX_NUM:
		case GDEV_ERR_MAPPOINTER:
			break;
		default:
			break;
		}
	}else{
		AfxMessageBox(IDS_ERROR_INPUTVALUE, (MB_ICONEXCLAMATION | MB_OK) );
		return;	
	}
}

/////////////////////////////////////////////////////////////////////////////
// GB Device Write.

void CGTDevmonSampleDlg::GBDevAccess(bool flag)
{
	char	cBuff[32];
	short	sData_tbl[4096];
	int		iId_no;
	long	lResultRD = 0, lResultWD = 0;
	static	unsigned	short	usTable[] = {
				0x0001,0x0002,0x0004,0x0008,0x0010,0x0020,0x0040,0x0080,
				0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x8000
	};

	if(m_ulDev_MapPointer == 0){
		AfxMessageBox(IDS_WARNING_MON_STOP, (MB_ICONEXCLAMATION | MB_OK) );
		return;
	}

	GetDlgItemText(IDC_GB_EDIT,cBuff,32);
	
	lResultRD = GDev_Read(m_ulDev_MapPointer, GB_DEV_ID, (atoi(cBuff)/16)*16, (short *)sData_tbl, 1);

	switch(lResultRD){
	case GDEV_OK:
		if(flag == true){
			iId_no = atoi(cBuff)%16;
			sData_tbl[0] |= usTable[iId_no];
		}else{
			iId_no = atoi(cBuff)%16;
			sData_tbl[0] &= ~usTable[iId_no];
		}
		lResultWD = GDev_Write(m_ulDev_MapPointer, GB_DEV_ID, (atoi(cBuff)/16)*16, (short *)sData_tbl, 1);
		switch(lResultWD){
		case GDEV_OK:
			break;
		case GDEV_ERR_DEV_NAME_ID:
		case GDEV_ERR_DEV_MIN_NUM:
		case GDEV_ERR_DEV_MAX_NUM:
		case GDEV_ERR_MAPPOINTER:
			break;
		default:
			break;
		}
		break;
	case GDEV_ERR_DEV_NAME_ID:
	case GDEV_ERR_DEV_MIN_NUM:
	case GDEV_ERR_DEV_MAX_NUM:
	case GDEV_ERR_MAPPOINTER:
		break;
	default:
		break;
	}
}

/////////////////////////////////////////////////////////////////////////////
// GS Device Write.

void CGTDevmonSampleDlg::OnGsWriteBtn() 
{
	char	cDevbuff[32], cValbuff[32];
	short	sData_tbl[256];
	long	lResult = 0, lInputValue = 0;

	sData_tbl[0] = 0;

	if(m_ulDev_MapPointer == 0){
		AfxMessageBox(IDS_WARNING_MON_STOP, (MB_ICONEXCLAMATION | MB_OK) );
		return;
	}

	GetDlgItemText(IDC_GS_EDIT,cDevbuff,32);
	GetDlgItemText(IDC_GS_EDIT_W,cValbuff,32);

	lInputValue = atoi(cValbuff);

	if((lInputValue >= INPUTVAL_MIN && lInputValue < 0) ||
		(lInputValue > 0 && lInputValue <= INPUTVAL_MAX) ||
		(cValbuff[0] == '0') ){
		sData_tbl[0] = (short)lInputValue;
		lResult = GDev_Write(m_ulDev_MapPointer, GS_DEV_ID, atoi(cDevbuff), (short *)sData_tbl, 1);
		switch(lResult){
		case GDEV_OK:
			break;
		case GDEV_ERR_DEV_NAME_ID:
		case GDEV_ERR_DEV_MIN_NUM:
		case GDEV_ERR_DEV_MAX_NUM:
		case GDEV_ERR_MAPPOINTER:
			break;
		default:
			break;
		}
	}else{
		AfxMessageBox(IDS_ERROR_INPUTVALUE, (MB_ICONEXCLAMATION | MB_OK) );
		return;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Monitor routine.

void CGTDevmonSampleDlg::OnTimer(UINT nIDEvent) 
{
	short	sData_tbl[256];
	char	cString[256];
	char	cBuff[32];
	long	lDevice_No = 0, lResult = 0;

	static	unsigned	short	usTable[] = {
			0x0001,0x0002,0x0004,0x0008,0x0010,0x0020,0x0040,0x0080,
			0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x8000
	};

	// Device error check.
	if(m_ulDev_MapPointer == 0){
		KillTimer( 1 );
		AfxMessageBox(IDS_ERROR_MEM_ACCESS, (MB_ICONSTOP | MB_OK) );
		::PostQuitMessage(0);
		return;
	}

	// GB Device Access.
	GetDlgItemText(IDC_GB_EDIT,cBuff,32);
	lDevice_No = GTDeviceRangeCorrect(IDC_GB_EDIT,IDC_GB_SPIN,atoi(cBuff));
	lResult = GDev_Read(m_ulDev_MapPointer, GB_DEV_ID, (lDevice_No/16)*16, sData_tbl, 1);
	switch(lResult){
	case GDEV_OK:
		lDevice_No = lDevice_No%16;
		strcpy(cBuff,"\0");
		if	(sData_tbl[0] & usTable[lDevice_No]){
			strcat(cBuff,"1");
		}else{
			strcat(cBuff,"0");
		}
		SetDlgItemText(IDC_GB_EDIT_R,cBuff);
		break;
	case GDEV_ERR_DEV_NAME_ID:
	case GDEV_ERR_DEV_MIN_NUM:
	case GDEV_ERR_DEV_MAX_NUM:
	case GDEV_ERR_MAPPOINTER:
		break;
	default:
		break;
	}

	// GD Device Access.
	GetDlgItemText(IDC_GD_EDIT,cBuff,32);
	lDevice_No = GTDeviceRangeCorrect(IDC_GD_EDIT,IDC_GD_SPIN,atoi(cBuff));
	lResult = GDev_Read(m_ulDev_MapPointer, GD_DEV_ID, lDevice_No, sData_tbl, 1);
	switch(lResult){
	case GDEV_OK:
		sprintf(cString,"%6d",sData_tbl[0]);
		SetDlgItemText(IDC_GD_EDIT_R,cString);
		break;
	case GDEV_ERR_DEV_NAME_ID:
	case GDEV_ERR_DEV_MIN_NUM:
	case GDEV_ERR_DEV_MAX_NUM:
	case GDEV_ERR_MAPPOINTER:
		break;
	default:
		break;
	}

	// GS Device Access.
	GetDlgItemText(IDC_GS_EDIT,cBuff,32);
	lDevice_No = GTDeviceRangeCorrect(IDC_GS_EDIT,IDC_GS_SPIN,atoi(cBuff));
	lResult = GDev_Read(m_ulDev_MapPointer, GS_DEV_ID, lDevice_No, sData_tbl, 1);
	switch(lResult){
	case GDEV_OK:
		sprintf(cString,"%6d",sData_tbl[0]);
		SetDlgItemText(IDC_GS_EDIT_R,cString);
		break;
	case GDEV_ERR_DEV_NAME_ID:
	case GDEV_ERR_DEV_MIN_NUM:
	case GDEV_ERR_DEV_MAX_NUM:
	case GDEV_ERR_MAPPOINTER:
		break;
	default:
		break;
	}

	CDialog::OnTimer(nIDEvent);
}

/////////////////////////////////////////////////////////////////////////////
// Dialog Close.

void CGTDevmonSampleDlg::OnCancel() 
{
	if(m_hDev_MapFile != NULL && m_ulDev_MapPointer != 0){
		if(AfxMessageBox(IDS_MONITOR_STOP, (MB_ICONEXCLAMATION | MB_OKCANCEL) ) == IDOK){
			KillTimer( 1 );

			GDev_CloseUnMapping(m_hDev_MapFile,m_ulDev_MapPointer);

			m_ulDev_MapPointer = 0;
			m_hDev_MapFile = NULL;
		}else{
			return;
		}
	}
	CDialog::OnCancel();
}

/////////////////////////////////////////////////////////////////////////////
// Messgae.

BOOL CGTDevmonSampleDlg::PreTranslateMessage(MSG *pMsg)
{
    switch (pMsg->message)
    {
    case WM_MOUSEMOVE:
        m_ToolTip.RelayEvent (pMsg);
        break;
	case WM_KEYDOWN:
		if( pMsg->wParam == VK_ESCAPE || pMsg->wParam == VK_RETURN)
			return( TRUE );
    default:
        break;
    }
    return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// Device range check.

void CGTDevmonSampleDlg::GTDeviceRangeCheck(UINT EdiCtrlId, UINT SpnCtrlId)
{
	INT		iLower,iUpper;
	CHAR	cDevbuff[32], cLowbuff[32], cUpbuff[32];

	CSpinButtonCtrl* pSB=(CSpinButtonCtrl*)GetDlgItem(SpnCtrlId);
	pSB->GetRange32(iLower,iUpper);

	GetDlgItemText(EdiCtrlId,cDevbuff,32);
	if((UINT)atoi(cDevbuff) > (UINT)iUpper || atoi(cDevbuff) < iLower){
		AfxMessageBox(IDS_WARNING_DEV_OVR, (MB_ICONEXCLAMATION | MB_OK) );

		if(atoi(cDevbuff) > iUpper){
			SetDlgItemText(EdiCtrlId,itoa(iUpper,cUpbuff,10));
		}else{
			SetDlgItemText(EdiCtrlId,itoa(iLower,cLowbuff,10));
		}
		((CEdit*)GetDlgItem(EdiCtrlId))->SetFocus();

	}else if(cDevbuff[0] == NULL){
		SetDlgItemText(EdiCtrlId,"0");
	}
	return;
}

ULONG CGTDevmonSampleDlg::GTDeviceRangeCorrect(UINT EdiCtrlId , UINT SpnCtrlId , LONG SetValue)
{
	ULONG	iValue = 0;
	INT		iLower = 0,iUpper = 0;

	CSpinButtonCtrl* pSB=(CSpinButtonCtrl*)GetDlgItem(SpnCtrlId);
	pSB->GetRange32(iLower,iUpper);

	if(SetValue > iUpper){
		iValue = iUpper;
	}else if(SetValue < iLower){
		iValue = iLower;
	}else{
		iValue = SetValue;
	}
	return iValue;
}
